<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CourseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'picture' => $this->picture,
            'users' => UserResource::collection($this->users),
            'sessions' => SessionResource::collection($this->sessions),
            'discussions' => DiscussionResource::collection($this->discussions)
        ];
    }
}
