<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Resources\UserResource;
use App\Models\User;
use App\Traits\GenericApiResponse;

class UsersController extends Controller
{
    use GenericApiResponse;

    public function index(Request $request)
    {
        $users = User::paginate($request->per_page ?? 30);

        return UserResource::collection($users);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email:rfc,dns',
            'password' => 'required|min:6|confirmed'
        ]);

        $user = User::create($request->all());

        if($user){
            return $this->successResponse('User berhasil dibuat');
        }

        return $this->errorResponse(null, 500);
    }
}
