<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Traits\GenericApiResponse;
use App\Models\Organization;

class OrganizationsController extends Controller
{
    use GenericApiResponse;

    public function index(Request $request)
    {
        if($request->input('per_page')){
            $orgs = Organization::paginate($request->per_page ?? 30);
        }else{
            $orgs = Organization::all();
        }

        return response()->json($orgs);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);

        $org = Organization::create($request->all());

        if($org){
            return $this->successResponse('User berhasil dibuat', 200, $org);
        }

        return $this->errorResponse(null, 500);
    }
}
