<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Discussion;
use App\Traits\GenericApiResponse;
use App\Http\Resources\DiscussionResource;

class DiscussionsController extends Controller
{
    use GenericApiResponse;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'body' => 'required'
        ]);

        Discussion::create([
            'session_id' => $request->input('session_id'),
            'course_id' => $request->input('course_id'),
            'user_id' => auth()->user()->id,
            'body' => $request->input('body'),
        ]);

        return $this->successResponse('Berhasil');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getForCourse($id)
    {
        $discussions = Discussion::where('course_id', $id)->orderBy('created_at')->get();

        return DiscussionResource::collection($discussions);
    }

    public function getForSession($id)
    {
        $discussions = Discussion::where('session_id', $id)->orderBy('created_at')->get();

        return DiscussionResource::collection($discussions);
    }
}
