<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Course;
use App\Http\Resources\CourseResource;
use App\Traits\GenericApiResponse;

class CoursesController extends Controller
{
    use GenericApiResponse;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $courses = Course::orderBy('created_at', 'ASC')->paginate($request->per_page ?? 10);

        return CourseResource::collection($courses);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required'
        ]);

        $course = Course::create($request->all());
        $course->users()->sync($request->users);

        return $this->successResponse();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $course = Course::find($id);

        if($course){
            return (new CourseResource($course));
        }

        return $this->errorResponse();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $course = Course::find($id);

        if($course){
            $course->update([
                'title' => $request->title,
                'description' => $request->description
            ]);

            $course->users()->sync($request->users);

            return $this->successResponse('Course berhasil diperbarui');
        }

        return $this->errorResponse('Course tidak ditemukan', 404);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $course = Course::find($id);

        if($course){
            $course->delete();

            return $this->successResponse('Course berhasil dihapus');
        }

        return $this->errorResponse();
    }
}
