<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Asset;
use App\Traits\GenericApiResponse;
use App\Http\Resources\AssetResource;

class AssetsController extends Controller
{
    use GenericApiResponse;
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $assets = Asset::orderBy('created_at', 'DESC')->paginate($request->per_page ?? 10);

        return AssetResource::collection($assets);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->file('files')){
            $ids = [];
            foreach($request->file('files') as $file){
                $original_filename = $file->getClientOriginalName();
                $path = $file->store('public');
                $asset = Asset::create([
                    'original_filename' => $original_filename,
                    'filename' => $path,
                    'user_id' => auth()->user()->id
                ]);

                $ids[] = $asset->id;
            }

            return $this->successResponse('Dokumen berhasil diupload', 200, $ids);
        }
        
        return $this->errorResponse('Nothing to upload', 422);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $asset = Asset::find($id);
        \Storage::delete($asset->filename);
        $asset->delete();

        return $this->successResponse('Dokumen Berhasil dihapus');
    }
}
