<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\UsersController;
use App\Http\Controllers\API\OrganizationsController;
use App\Http\Controllers\API\CoursesController;
use App\Http\Controllers\API\AssetsController;
use App\Http\Controllers\API\DiscussionsController;
use App\Http\Controllers\API\SessionsController;
use App\Http\Controllers\UploadController;
use App\Http\Controllers\API\DashboardController;
use App\Http\Controllers\API\RpamController;
use App\Http\Resources\UserResource;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('/login', [AuthController::class, 'login']);

Route::middleware('auth:sanctum')->get('/user/me', function (Request $request) {
    return new UserResource($request->user());
});

Route::middleware('auth:sanctum')->group(function(){
    Route::get('/user/me', function (Request $request) {
        return new UserResource($request->user());
    });

    Route::get('/dashboard', DashboardController::class);

    Route::post('/user/update-password', [UsersController::class, 'changePassword']);
    Route::post('/user/admin-update-password', [UsersController::class, 'changePasswordByAdmin']);

    Route::get('discussions/course/{id}', [DiscussionsController::class, 'getForCourse']);
    Route::get('discussions/session/{id}', [DiscussionsController::class, 'getForSession']);

    Route::post('courses/batchDelete', [CoursesController::class, 'batchDestroy']);

    Route::apiResource('/users', UsersController::class);
    Route::apiResource('/organizations', OrganizationsController::class);
    Route::apiResource('/courses', CoursesController::class);
    Route::apiResource('/assets', AssetsController::class);
    Route::apiResource('/discussions', DiscussionsController::class);
    Route::apiResource('/sessions', SessionsController::class);
    Route::apiResource('/rpam', RpamController::class);

    Route::post('/upload', UploadController::class);
});
