import {createRouter, createWebHistory} from 'vue-router';

const router = createRouter({
    history: createWebHistory(),
    routes: [
        {
            path: '/',
            name: 'login',
            component: () => import('@/views/Login.vue')
        },
        {
            path: '/dashboard',
            name: 'dashboard',
            component: () => import('@/views/Dashboard.vue')
        },
        {
            path: '/users',
            name: 'users_index',
            component: () => import('@/views/users/Index.vue')
        },
        {
            path: '/users/create',
            name: 'users_create',
            component: () => import('@/views/users/Create.vue')
        },
        {
            path: '/users/:id/edit',
            name: 'users_edit',
            component: () => import('@/views/users/Edit.vue')
        },
        {
            path: '/courses',
            name: 'courses_index',
            component: () => import('@/views/courses/Index.vue')
        },
        {
            path: '/courses/master',
            name: 'courses_index_master',
            component: () => import('@/views/courses/Index.vue')
        },
        {
            path: '/courses/create',
            name: 'courses_create',
            component: () => import('@/views/courses/Create.vue')
        },
        {
            path: '/courses/create/master',
            name: 'courses_create_master',
            component: () => import('@/views/courses/Create.vue')
        },
        {
            path: '/courses/:id',
            name: 'courses_show',
            component: () => import('@/views/courses/Show.vue')
        },
        {
            path: '/courses/:id/edit',
            name: 'courses_edit',
            component: () => import('@/views/courses/Edit.vue')
        },
        {
            path: '/courses/:course_id/sessions/:session_id',
            name: 'sessions_show',
            component: () => import('@/views/sessions/Show.vue')
        },
        {
            path: '/courses/:id/sessions/create',
            name: 'sessions_create',
            component: () => import('@/views/sessions/Create.vue')
        },
        {
            path: '/library',
            name: 'assets_index',
            component: () => import('@/views/assets_manager/Index.vue')
        },
        {
            path: '/test',
            name: 'test_index',
            component: () => import('@/views/quiz/Index.vue')
        },
        {
            path: '/test/create',
            name: 'test_create',
            component: () => import('@/views/quiz/Create.vue')
        }
    ],
})

router.beforeEach(async (to, from) => {
    if (to.name === 'login' && localStorage.getItem('access_token') !== null) {
        return { name: 'dashboard' }
    }

    if(to.name !== 'login' && localStorage.getItem('access_token') === null) {
        return { name: 'login' }
    }
})

export default router;