<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m10_3', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_208')->nullable()->comment('kode lokasi');
            $table->string('_209')->nullable()->comment('komponen diagram air');
            $table->string('_210')->nullable()->comment('penyebab');
            $table->string('_211')->nullable()->comment('bagaimana kejadian ini pertama kali diketahui');
            $table->string('_212')->nullable()->comment('Apa tindakan koreksi yang paling penting dilakukan?');
            $table->string('_213')->nullable()->comment('Siapa yang melakukannya?');
            $table->string('_214')->nullable()->comment('sebera cepat dilakukannya');
            $table->string('_215')->nullable()->comment('siapa yang harus diberitahu tentang dilakukannya tindakan ini');
            $table->string('_216')->nullable()->comment('apa masalah komunikasi yang muncul');
            $table->string('_217')->nullable()->comment('bagaimana mengatasi masalah komunikasi tersebut');
            $table->string('_218')->nullable()->comment('apa akibat yang langsung terjadi');
            $table->string('_219')->nullable()->comment('apa akibat jangka panjang');
            $table->string('_220')->nullable()->comment('sebarap baik POS terkait berfungsi');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m10_3');
    }
};
