<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m9_3', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_194')->nullable()->comment('jenis informasi');
            $table->string('_195')->nullable()->comment('frekuensi');
            $table->string('_196')->nullable()->comment('penanggung jawab');
            $table->string('_197')->nullable()->comment('penerima informasi');
            $table->string('_198')->nullable()->comment('media penyimpanan');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m9_3');
    }
};
