<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m9_2', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_188')->nullable()->comment('Jenis Informasi yang ingin Didapat/Disampaikan');
            $table->string('_189')->nullable()->comment('Bentuk Kegiatan');
            $table->string('_190')->nullable()->comment('Rencana Waktu Pelaksanaan');
            $table->string('_191')->nullable()->comment('Penanggung jawab');
            $table->string('_192')->nullable()->comment('Penerima/Sumber Informasi');
            $table->text('_193')->nullable()->comment('Media/Cara Penyampaian/Pengambilan Infromasi');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m9_2');
    }
};
