<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m9_1', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_181')->nullable()->comment('Kode Lokasi');
            $table->string('_182')->nullable()->comment('Komponen Diagram Air');
            $table->string('_183')->nullable()->comment('Kejadian Bahaya');
            $table->string('_184')->nullable()->comment('Tindakan Pengendalian yang Ada Saat Ini/Rencana Perbaikan');
            $table->text('_185')->nullable()->comment('Aktivitas');
            $table->text('_186')->nullable()->comment('Tujuan');
            $table->text('_187')->nullable()->comment('Program Pendukung');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m9_1');
    }
};
