<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m8_1', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_175')->nullable()->comment('kode lokasi');
            $table->string('_176')->nullable()->comment('komponen rantai pasok');
            $table->string('_177')->nullable()->comment('kejadian bahaya');
            $table->string('_178')->nullable()->comment('tindakan');
            $table->string('_179')->nullable()->comment('pos sudah ada');
            $table->string('_180')->nullable()->comment('pos perlu disusun');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m8_1');
    }
};
