<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m7_3', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_169')->nullable()->comment('lokasi survey');
            $table->string('_170')->nullable()->comment('puas');
            $table->string('_171')->nullable()->comment('tidak puas');
            $table->string('_172')->nullable()->comment('catatan');
            $table->string('_173')->nullable()->comment('frekuensi');
            $table->string('_174')->nullable()->comment('pelaksana');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m7_3');
    }
};
