<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m7_2', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->text('_164')->nullable()->comment('kegiatan audit');
            $table->text('_165')->nullable()->comment('deskripsi');
            $table->string('_166')->nullable()->comment('frekuensi pengumpulan');
            $table->string('_167')->nullable()->comment('pelaksana');
            $table->string('_168')->nullable()->comment('tempat penyimpanan dokumen');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m7_2');
    }
};
