<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m4_1', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_101')->nullable()->comment('kode lokasi');
            $table->string('_102')->nullable()->comment('komponen spam');
            $table->string('_103')->nullable()->comment('kejadian bahaya');
            $table->string('_104')->nullable()->comment('tipe bahaya');
            $table->string('_105')->nullable()->comment('risiko tanpa tindakan pengendalian (PK)');
            $table->string('_106')->nullable()->comment('risiko tanpa tindakan pengendalian (DK)');
            // $table->string('_107')->nullable()->comment(''); TIDAK DIGUNAKAN, skor harus dihitung dari PK * DK
            // $table->string('_108')->nullable()->comment(''); TIDAK DIGUNAKAN, skor harus dihitung dari PK * DK
            $table->string('_109')->nullable()->comment('tindakan pengendalian yang ada saat ini');
            $table->string('_110')->nullable()->comment('validasi (E)');
            $table->string('_111')->nullable()->comment('validasi (TE)');
            $table->string('_112')->nullable()->comment('validasi (TP)');
            $table->string('_113')->nullable()->comment('catatan validasi');
            $table->string('_114')->nullable()->comment('risiko dengan tindakan pengendalian (PK)');
            $table->string('_115')->nullable()->comment('risiko dengan tindakan pengendalian (DK)');
            // $table->string('_116')->nullable()->comment(''); TIDAK DIGUNAKAN, skor harus dihitung dari PK * DK
            // $table->string('_117')->nullable()->comment(''); TIDAK DIGUNAKAN, skor harus dihitung dari PK * DK
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m4_1');
    }
};
