<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m3_4', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_95')->nullable()->comment('kode lokasi');
            $table->string('_96')->nullable()->comment('komponen spam');
            $table->text('_97')->nullable()->comment('kejadian bahaya');
            $table->string('_98')->nullable()->comment('tipe bahaya');
            $table->integer('_99')->nullable()->comment('peluang kejadian');
            $table->integer('_100')->nullable()->comment('dampak keparahan');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m3_4');
    }
};
