<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m2_5', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_78')->nullable()->comment('kode lokasi');
            $table->string('_79')->nullable()->comment('nama lokasi');
            $table->text('_80')->nullable()->comment('kualitas air yang masuk');
            $table->text('_81')->nullable()->comment('kualitas air yang keluar');
            $table->text('_82')->nullable()->comment('standar/target kualitas air yang masuk');
            $table->text('_83')->nullable()->comment('standar/target kualitas air yang keluar');
            $table->text('_84')->nullable()->comment('performansi');
            $table->string('_85')->nullable()->comment('referensi');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m2_5');
    }
};
