<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m2_3', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('diagram_alir')->nullable()->comment('file diagram alir');
            $table->string('_72')->nullable()->comment('kode lokasi');
            $table->string('_73')->nullable()->comment('simbol');
            $table->text('_74')->nullable()->comment('nama lokasi');
            $table->text('_75')->nullable()->comment('deskripsi');
            $table->text('_76')->nullable()->comment('penanggung jawab');
            $table->text('_77')->nullable()->comment('referensi');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m2_3');
    }
};
