<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m2_2', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->text('_61')->nullable()->comment('Detil dan peta penggunaan lahan di wilayah penangkapan air');
            $table->text('_62')->nullable()->comment('Kondisi geologi dan hidrogeologi di sepanjang SPAM');
            $table->text('_63')->nullable()->comment('Sumber air baku termasuk limpasan dan/atau masukan (recharge),dan jika relevan, alternatif sumber air baku');
            $table->text('_64')->nullable()->comment('Perubahan kualitas air sumber yang diketahui ataupun diperkirakan terjadi, yang diakibatkan oleh kondisi iklim ataupun lainnya');
            $table->text('_65')->nullable()->comment('Interkoneksi antar sumber air baku dan dampaknya terhadap kualitas air');
            $table->text('_66')->nullable()->comment('Titik tangkapan air');
            $table->text('_67')->nullable()->comment('Penyimpanan air baku');
            $table->text('_68')->nullable()->comment('Pengolahan air termasuk satuan proses dan operasinya');
            $table->text('_69')->nullable()->comment('Distribusi air termasuk jaringan, penyimpanan dan tangki air');
            $table->text('_70')->nullable()->comment('Material yang digunakan sepanjang SPAM (pipa, penyimpanan, fittings, pompa)');
            $table->string('diagram_skematik')->nullable()->comment('Diagram skematik SPAM');
            $table->text('diagram_naratif')->nullable()->comment('Diagram naratif');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m2_2');
    }
};
