<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m2_1_ipam', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_46')->nullable()->comment('nama');
            $table->string('_47')->nullable()->comment('lokasi');
            $table->string('_48')->nullable()->comment('jumlah sumber air baku');
            $table->string('_49')->nullable()->comment('Wilayah pelayanan');
            $table->string('_50')->nullable()->comment('Populasi total di daerah pelayanan');
            $table->string('_51')->nullable()->comment('Populasi total yang dilayani di daerah pelayanan');
            $table->string('_52')->nullable()->comment('Kebutuhan air penduduk total di wilayah pelayanan');
            $table->string('_53')->nullable()->comment('Volume air yang didistribusikan di wilayah pelayanan');
            $table->string('_54')->nullable()->comment('Durasi pelayanan');
            $table->string('_55')->nullable()->comment('tekanan');
            $table->string('_56')->nullable()->comment('Wilayah yang disuplai sewaktu-waktu');
            $table->string('_57')->nullable()->comment('Kehilangan air');
            $table->string('_58')->nullable()->comment('Durasi waktu pemeriksaan kualitas air produksi');
            $table->string('_59')->nullable()->comment('Nama Laboratorium');
            $table->string('_60')->nullable()->comment('Lokasi');
            $table->string('_223')->nullable()->comment('Informasi akreditasi laboratorium');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m2_1_ipam');
    }
};
