<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m2_1', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_31')->nullable()->comment('Wilayah Pelayanan');
            $table->string('_32')->nullable()->comment('Populasi Penduduk');
            $table->string('_33')->nullable()->comment('Kebutuhan air penduduk total');
            $table->string('_34')->nullable()->comment('Volume total air yang didistribusikan');
            $table->string('_35')->nullable()->comment('Persentase Pelayanan');
            $table->string('_36')->nullable()->comment('Jumlah Unit IPAM');
            $table->text('_37')->nullable()->comment('Riwayat isu kualitas air baku');
            $table->text('_38')->nullable()->comment('Riwayat isu kualitas air minum');
            $table->string('_39')->nullable()->comment('Jumlah SPAM yang mengaplikasikan RPAM');
            $table->string('_40')->nullable()->comment('Jumlah total pegawai');
            $table->string('_41')->nullable()->comment('Jumlah total pegawai per sambungan');
            $table->string('_221')->nullable()->comment('Jumlah dan tipe sambungan (domestik, komersil, industri, kepentingan umum dll.)');
            $table->string('_222')->nullable()->comment('Jumlah total pegawai per sambungan');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m2_1');
    }
};
