<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m1_3', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_22')->nullable()->comment('kode lokasi');
            $table->string('_23')->nullable()->comment('nama lokasi');
            $table->string('_24')->nullable()->comment('pemangku kepentingan');
            $table->string('_25')->nullable()->comment('hubungan dengan RPAM');
            $table->text('_26')->nullable()->comment('isu utama');
            $table->text('_27')->nullable()->comment('detail kontak tim RPAM');
            $table->text('_28')->nullable()->comment('detail kontak pemangku kepentingan');
            $table->text('_29')->nullable()->comment('mekanisme interaksi');
            $table->string('_30')->nullable()->comment('informasi rekaman pertemuan');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('m1_3');
    }
};
