<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m1_1', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->string('_9')->nullable()->comment('nomor dokumen');
            $table->string('_10')->nullable()->comment('kota');
            $table->string('_11')->nullable()->comment('tanggal dokumen');
            $table->string('_12')->nullable()->comment('nama direktur');
            $table->string('_13')->nullable()->comment('NIP direktur');
            $table->string('_14')->nullable()->comment('nama anggota tim');
            $table->string('_15')->nullable()->comment('jabatan anggota tim');
            $table->string('_16')->nullable()->comment('keahlian anggota tim');
            $table->text('_17')->nullable()->comment('peran anggota tim');
            $table->text('_18')->nullable()->comment('detail kontal');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('module1_1s');
    }
};
