<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('m1_0', function (Blueprint $table) {
            $table->id();
            $table->integer('rpam_id')->unsigned();
            $table->text('_1')->nullable()->comment('visi');
            $table->text('_2')->nullable()->comment('misi');
            $table->string('_3')->nullable()->comment('nomor dokumen');
            $table->string('_4')->nullable()->comment('tahun dokumen');
            $table->string('_5')->nullable()->comment('kota dokumen dibuat');
            $table->string('_6')->nullable()->comment('tanggal dokumen dibuat');
            $table->string('_7')->nullable()->comment('nama direktur');
            $table->string('_8')->nullable()->comment('NIP direktur');
            $table->timestamps();

            $table->foreign('rpam_id')->references('id')->on('rpam')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('module1_0s');
    }
};
