<?php
namespace App\Traits;

use Illuminate\Http\Request;
use App\Models\Module7_1;
use App\Models\Module7_2;
use App\Models\Module7_3;

trait RpamModule7Trait {
    public function updateM7(Request $request, $id) : void {
        $this->updateM7_1($request, $id);
        $this->updateM7_2($request, $id);
        $this->updateM7_3($request, $id);
    }

    function updateM7_1(Request $request, $id) : void {
        Module7_1::where('rpam_id', $id)->delete();

        if (isset($request->m7_1_data)) {
            for ($i = 0; $i < count($request->m7_1_data); $i++) {
                Module7_1::create([
                    "rpam_id" => $id,
                    '_160' => $request->m7_1_data[$i]['_160'],
                    '_161' => $request->m7_1_data[$i]['_161'],
                    '_162' => $request->m7_1_data[$i]['_162'],
                    '_163' => $request->m7_1_data[$i]['_163'],
                ]);
            }
        }
    }

    function updateM7_2(Request $request, $id) : void {
        Module7_2::where('rpam_id', $id)->delete();

        if (isset($request->m7_2_data)) {
            for ($i = 0; $i < count($request->m7_2_data); $i++) {
                Module7_2::create([
                    "rpam_id" => $id,
                    '_164' => $request->m7_2_data[$i]['_164'],
                    '_165' => $request->m7_2_data[$i]['_165'],
                    '_166' => $request->m7_2_data[$i]['_166'],
                    '_167' => $request->m7_2_data[$i]['_167'],
                    '_168' => $request->m7_2_data[$i]['_168'],
                ]);
            }
        }
    }

    function updateM7_3(Request $request, $id) : void {
        Module7_3::where('rpam_id', $id)->delete();

        if (isset($request->m7_3_data)) {
            for ($i = 0; $i < count($request->m7_3_data); $i++) {
                Module7_3::create([
                    "rpam_id" => $id,
                    '_169' => $request->m7_3_data[$i]['_169'],
                    '_170' => $request->m7_3_data[$i]['_170'],
                    '_171' => $request->m7_3_data[$i]['_171'],
                    '_172' => $request->m7_3_data[$i]['_172'],
                    '_173' => $request->m7_3_data[$i]['_173'],
                    '_174' => $request->m7_3_data[$i]['_174'],
                ]);
            }
        }
    }
}