<?php
namespace App\Traits;

use Illuminate\Http\Request;
use App\Models\Module2_1;
use App\Models\Module2_1_sab;
use App\Models\Module2_1_ipam;
use App\Models\Module2_2;
use App\Models\Module2_3;
use App\Models\Module2_5;
use App\Models\Module2_6;

trait RpamModule2Trait {
    public function updateM2(Request $request, $id) : void {
        $this->updateM2_1($request, $id);
        $this->updateM2_1_sab($request, $id);
        $this->updateM2_1_ipam($request, $id);
        $this->updateM2_2($request, $id);
        $this->updateM2_3($request, $id);
        $this->updateM2_5($request, $id);
        $this->updateM2_6($request, $id);
    }

    public function updateM2_1(Request $request, $id) : void {
        Module2_1::updateOrCreate(['rpam_id' => $id], $request->m2_1_data);
    }

    public function updateM2_1_sab(Request $request, $id) : void {
        Module2_1_sab::where('rpam_id', $id)->delete();

        if (isset($request->m2_1_data['sumber_air_baku'])) {
            for ($i = 0; $i < count($request->m2_1_data['sumber_air_baku']); $i++) {
                Module2_1_sab::create([
                    "rpam_id" => $id,
                    "_42" => $request->m2_1_data['sumber_air_baku'][$i]['_42'] ?? null,
                    "_43" => $request->m2_1_data['sumber_air_baku'][$i]['_43'] ?? null,
                    "_44" => $request->m2_1_data['sumber_air_baku'][$i]['_44'] ?? null,
                    "_45" => $request->m2_1_data['sumber_air_baku'][$i]['_45'] ?? null,
                ]);
            }
        }
    }

    public function updateM2_1_ipam(Request $request, $id) : void {
        Module2_1_ipam::where('rpam_id', $id)->delete();

        if (isset($request->m2_1_data['ipam'])) {
            for ($i = 0; $i < count($request->m2_1_data['ipam']); $i++) {
                Module2_1_ipam::create([
                    "rpam_id" => $id,
                    '_46' => $request->m2_1_data['ipam'][$i]['_46'] ?? null,
                    '_47' => $request->m2_1_data['ipam'][$i]['_47'] ?? null,
                    '_48' => $request->m2_1_data['ipam'][$i]['_48'] ?? null,
                    '_49' => $request->m2_1_data['ipam'][$i]['_49'] ?? null,
                    '_50' => $request->m2_1_data['ipam'][$i]['_50'] ?? null,
                    '_51' => $request->m2_1_data['ipam'][$i]['_51'] ?? null,
                    '_52' => $request->m2_1_data['ipam'][$i]['_52'] ?? null,
                    '_53' => $request->m2_1_data['ipam'][$i]['_53'] ?? null,
                    '_54' => $request->m2_1_data['ipam'][$i]['_54'] ?? null,
                    '_55' => $request->m2_1_data['ipam'][$i]['_55'] ?? null,
                    '_56' => $request->m2_1_data['ipam'][$i]['_56'] ?? null,
                    '_57' => $request->m2_1_data['ipam'][$i]['_57'] ?? null,
                    '_58' => $request->m2_1_data['ipam'][$i]['_58'] ?? null,
                    '_59' => $request->m2_1_data['ipam'][$i]['_59'] ?? null,
                    '_60' => $request->m2_1_data['ipam'][$i]['_60'] ?? null,
                    '_223' => $request->m2_1_data['ipam'][$i]['_223'] ?? null,
                ]);
            }
        }
    }

    public function updateM2_2(Request $request, $id): void
    {
        Module2_2::updateOrCreate(['rpam_id' => $id], $request->m2_2_data);
    }

    public function updateM2_3(Request $request, $id) : void {
        Module2_3::where('rpam_id', $id)->delete();

        if (isset($request->m2_3_data)) {
            for ($i = 0; $i < count($request->m2_3_data); $i++) {
                Module2_3::create([
                    "rpam_id" => $id,
                    '_72' => $request->m2_3_data[$i]['_72'] ?? null,
                    '_73' => $request->m2_3_data[$i]['_73'] ?? null,
                    '_74' => $request->m2_3_data[$i]['_74'] ?? null,
                    '_75' => $request->m2_3_data[$i]['_75'] ?? null,
                    '_76' => $request->m2_3_data[$i]['_76'] ?? null,
                    '_77' => $request->m2_3_data[$i]['_77'] ?? null,
                    'diagram_alir' => $request->m2_3_data[$i]['diagram_alir'] ?? null,
                ]);
            }
        }
    }

    public function updateM2_5(Request $request, $id) : void {
        Module2_5::where('rpam_id', $id)->delete();

        if (isset($request->m2_5_data)) {
            for ($i = 0; $i < count($request->m2_5_data); $i++) {
                Module2_5::create([
                    "rpam_id" => $id,
                    '_78' => $request->m2_5_data[$i]['_78'] ?? null,
                    '_79' => $request->m2_5_data[$i]['_79'] ?? null,
                    '_80' => $request->m2_5_data[$i]['_80'] ?? null,
                    '_81' => $request->m2_5_data[$i]['_81'] ?? null,
                    '_82' => $request->m2_5_data[$i]['_82'] ?? null,
                    '_83' => $request->m2_5_data[$i]['_83'] ?? null,
                    '_84' => $request->m2_5_data[$i]['_84'] ?? null,
                    '_85' => $request->m2_5_data[$i]['_85'] ?? null,
                ]);
            }
        }
    }

    public function updateM2_6(Request $request, $id) : void {
        Module2_6::where('rpam_id', $id)->delete();

        if (isset($request->m2_6_data)) {
            for ($i = 0; $i < count($request->m2_6_data); $i++) {
                Module2_6::create([
                    "rpam_id" => $id,
                    '_86' => $request->m2_6_data[$i]['_86'] ?? null,
                    '_87' => $request->m2_6_data[$i]['_87'] ?? null,
                ]);
            }
        }
    }
}