<?php
namespace App\Traits;

use Illuminate\Http\Request;
use App\Models\Module1_0;
use App\Models\Module1_1;
use App\Models\Module1_2;
use App\Models\Module1_3;

trait RpamModule1Trait {
    public function updateM1(Request $request, $id){
        $this->updateM1_0($request, $id);
        $this->updateM1_1($request, $id);
        $this->updateM1_2($request, $id);
        $this->updateM1_3($request, $id);
    }

    public function updateM1_0(Request $request, $id) : void {
        Module1_0::updateOrCreate(['rpam_id' => $id], $request->m1_0_data);
    }

    public function updateM1_1(Request $request, $id) : void {
        Module1_1::where(['rpam_id' => $id])->delete();

        if(isset($request->m1_1_data['items'])){
            for($i = 0; $i < count($request->m1_1_data['items']); $i++){
                Module1_1::create([
                    "rpam_id" => $id,
                    "_9" => $request->m1_1_data['_9'] ?? null,
                    "_10" => $request->m1_1_data['_10'] ?? null,
                    "_11" => $request->m1_1_data['_11'] ?? null,
                    "_12" => $request->m1_1_data['_12'] ?? null,
                    "_13" => $request->m1_1_data['_13'] ?? null,
                    "_14" => $request->m1_1_data['items'][$i]['_14'] ?? null,
                    "_15" => $request->m1_1_data['items'][$i]['_15'] ?? null,
                    "_16" => $request->m1_1_data['items'][$i]['_16'] ?? null,
                    "_17" => $request->m1_1_data['items'][$i]['_17'] ?? null,
                    "_18" => $request->m1_1_data['items'][$i]['_18'] ?? null,
                    "ttd" => $request->m1_1_data['ttd'] ?? null
                ]);
            }
        }
    }

    public function updateM1_2(Request $request, $id) : void {
        Module1_2::where(['rpam_id' => $id])->delete();

        if(isset($request->m1_2_data['items'])){
            for($i = 0; $i < count($request->m1_2_data['items']); $i++){
                Module1_2::create([
                    "rpam_id" => $id,
                    "_19" => $request->m1_2_data['items'][$i]['_19'] ?? null,
                    "_20" => $request->m1_2_data['items'][$i]['_20'] ?? null,
                    "_21" => implode(',', $request->m1_2_data['items'][$i]['_21']),
                    "year_start" => $request->m1_2_data['items'][$i]['year_start'] ?? null,
                    "year_end" => $request->m1_2_data['items'][$i]['year_end'] ?? null,
                    "month_start" => $request->m1_2_data['items'][$i]['month_start'] ?? null,
                    "month_end" => $request->m1_2_data['items'][$i]['month_end'] ?? null,
                ]);
            }
        }
    }

    function updateM1_3(Request $request, $id) : void {
        Module1_3::where(['rpam_id' => $id])->delete();

        if(isset($request->m1_3_data['items'])){
            for($i = 0; $i < count($request->m1_3_data['items']); $i++){
                Module1_3::create([
                    "rpam_id" => $id,
                    "_22" => $request->m1_3_data['items'][$i]['_22'] ?? null,
                    "_23" => $request->m1_3_data['items'][$i]['_23'] ?? null,
                    "_24" => $request->m1_3_data['items'][$i]['_24'] ?? null,
                    "_25" => $request->m1_3_data['items'][$i]['_25'] ?? null,
                    "_26" => $request->m1_3_data['items'][$i]['_26'] ?? null,
                    "_27" => $request->m1_3_data['items'][$i]['_27'] ?? null,
                    "_28" => $request->m1_3_data['items'][$i]['_28'] ?? null,
                    "_29" => $request->m1_3_data['items'][$i]['_29'] ?? null,
                    "_30" => $request->m1_3_data['items'][$i]['_30'] ?? null,
                ]);
            }
        }
    }
}