<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Session extends Model
{
    use HasFactory;

    protected $fillable = ['course_id', 'title', 'description', 'sort', 'live', 'youtube_video'];

    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function files()
    {
        return $this->hasMany(SessionFile::class);
    }

    public function discussions()
    {
        return $this->hasMany(Discussion::class);
    }
}
