<?php

namespace App\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Course extends Model
{
    use HasFactory, Filterable;

    protected $fillable = [
        'title',
        'description',
        'picture',
        'start_date_time',
        'is_master',
        'instructor_id',
        'is_online'
    ];

    public function users()
    {
        return $this->belongsToMany(User::class);
    }

    public function sessions()
    {
        return $this->hasMany(Session::class)->orderBy('sort', 'ASC');
    }

    public function discussions()
    {
        return $this->hasMany(Discussion::class);
    }

    public function instructor()
    {
        return $this->belongsTo(User::class, 'instructor_id');
    }

    function scopeIsOnline($query, $is_online) {
        if($is_online !== 'a'){
            $query->where('is_online', $is_online);
        }
    }
}
