<?php 

namespace App\ModelFilters;

use EloquentFilter\ModelFilter;

class UserFilter extends ModelFilter
{
    /**
    * Related Models that have ModelFilters as well as the method on the ModelFilter
    * As [relationMethod => [input_key1, input_key2]].
    *
    * @var array
    */
    public $relations = [];
    
    public function name($name) {
        return $this->where('name', 'ILIKE', '%' . $name . '%');
    }

    public function email($email) {
        return $this->where('email', 'ILIKE', '%' . $email . '%');
    }

    public function role($role) {
        return $this->where('role', $role);
    }

    public function organization($name) {
        $this->related('organization', 'name', 'ILIKE', '%' . $name . '%');
    }
}
