<?php 

namespace App\ModelFilters;

use EloquentFilter\ModelFilter;

class OrganizationFilter extends ModelFilter
{
    /**
    * Related Models that have ModelFilters as well as the method on the ModelFilter
    * As [relationMethod => [input_key1, input_key2]].
    *
    * @var array
    */
    public $relations = [];

    public function name($name) {
        return $this->where('name', 'ILIKE', '%' . $name . '%');
    }

    public function address($address) {
        return $this->where('address', 'ILIKE', '%' . $address . '%');
    }

    public function province($province) {
        return $this->where('city', 'ILIKE', '%' . $province . '%');
    }

    public function city($city) {
        return $this->where('city', 'ILIKE', '%' . $city . '%');
    }
}
