<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CourseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'is_online' => $this->is_online,
            'title' => $this->title,
            'description' => $this->description,
            'is_picture_uploaded' => ($this->picture !== null),
            'picture' => $this->picture !== null ? \Storage::url($this->picture):asset('images/no-img-placeholder.png'),
            'picture_original_path' => $this->picture,
            'users' => UserResource::collection($this->users),
            'sessions' => SessionResource::collection($this->sessions),
            'discussions' => DiscussionResource::collection($this->discussions),
            'is_master' => $this->is_master,
            'start_date_time' => $this->start_date_time,
            'instructor' => $this->instructor !== null ? new UserResource($this->instructor):null
        ];
    }
}
