<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AssetResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'download' => \Storage::url($this->filename),
            'path' => $this->filename,
            'filename' => $this->original_filename,
            'created_at' => $this->created_at->format('d F Y H:i'),
            'uploader' => new UserResource($this->user)
        ];
    }
}
