<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Resources\UserResource;
use App\Models\User;
use App\Models\Menu;
use App\Traits\GenericApiResponse;

class UsersController extends Controller
{
    use GenericApiResponse;

    public function index(Request $request)
    {
        // if($request->role){
        //     $users = User::where('role', $request->role)->paginate($request->per_page ?? 30);
        // }else{
            $users = User::filter($request->all())->paginate($request->per_page ?? 10);
        // }

        return UserResource::collection($users);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email:rfc,dns',
            'password' => 'required|min:6|confirmed'
        ]);

        $data = $request->all();
        $data['password'] = bcrypt($request->input('password'));

        $user = User::create($data);

        $menus = [];
        foreach($request->menu as $menu){
            $menus[] = new Menu(['menu_name' => $menu]);
        }
        $user->menus()->saveMany($menus);

        if($user){
            return $this->successResponse('User berhasil dibuat');
        }

        return $this->errorResponse(null, 500);
    }

    public function show($id){
        $user = User::find($id);

        if($user) {
            return new UserResource($user);
        }

        $this->errorResponse('user tidak ditemukan', 404);
    }

    public function update(Request $request, $id) {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email:rfc,dns'
        ]);

        $user = User::find($id);
        if($user){
            // delete menu
            $user->menus()->delete();

            // then recreate
            $menus = [];
            foreach($request->menu as $menu){
                $menus[] = new Menu(['menu_name' => $menu]);
            }
            $user->menus()->saveMany($menus);

            $user->update($request->all());

            return $this->successResponse('User berhasil diubah');
        }

        $this->errorResponse('user tidak ditemukan', 404);
    }

    public function changePassword(Request $request){
        $request->validate([
            'password' => 'current_password',
            'new_password' => 'min:6|confirmed'
        ], [
            'password.current_password' => 'password salah',
            'new_password.min' => 'password minimal 6 digit',
            'new_passowrd.confirmed' => 'password baru tidak cocok'
        ]);

        $user = $request->user();

        if($user){
            $user->update([
                'password' => bcrypt($request->new_password)
            ]);

            return $this->successResponse('Password berhasil diubah');
        }

        $this->errorResponse('user tidak ditemukan', 404);
    }

    public function changePasswordByAdmin(Request $request){
        if($request->user()->role !== 'superadmin'){
            return $this->errorResponse('Anda tidak berhak mengganti password pengguna lain', 402);
        }

        $request->validate([
            'new_password' => 'min:6|confirmed'
        ], [
            'new_password.min' => 'password minimal 6 digit',
            'new_passowrd.confirmed' => 'password baru tidak cocok'
        ]);

        $user = User::find($request->id);

        if($user){
            $user->update([
                'password' => bcrypt($request->new_password)
            ]);

            return $this->successResponse('Password berhasil diubah');
        }

        $this->errorResponse('user tidak ditemukan', 404);
    }
}
