<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Rpam;
use App\Traits\RpamModule1Trait;
use App\Traits\RpamModule2Trait;
use App\Traits\RpamModule3Trait;
use App\Traits\RpamModule4Trait;
use App\Traits\RpamModule5Trait;
use App\Traits\RpamModule6Trait;
use App\Traits\RpamModule7Trait;
use App\Traits\RpamModule8Trait;
use App\Traits\RpamModule9Trait;
use App\Traits\RpamModule10Trait;

class RpamController extends Controller
{

    use RpamModule1Trait, 
    RpamModule2Trait, 
    RpamModule3Trait, 
    RpamModule4Trait, 
    RpamModule5Trait, 
    RpamModule6Trait, 
    RpamModule7Trait, 
    RpamModule8Trait,
    RpamModule9Trait,
    RpamModule10Trait;
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->user()->role === 'peserta'){
            $rpams = Rpam::where('organization_id', $request->user()->organization_id)->paginate($request->per_page ?? 10);
        }else{
            $rpams = Rpam::paginate($request->per_page ?? 10);
        }

        return response()->json($rpams);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required'
        ]);

        $data = $request->all();
        $data['organization_id'] = $request->user()->organization_id;

        $rpam = Rpam::create($data);

        return response()->json([
            'rpam' => $rpam
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request, $id)
    {
        $include = [];

        switch($request->module){
            case "1":
                $include = [
                    'module1_0',
                    'module1_1',
                    'module1_2',
                    'module1_3',
                ];
                break;

            case "2":
                $include = [
                    'module2_1',
                    'module2_1_sab',
                    'module2_1_ipam',
                    'module2_2',
                    'module2_3',
                    'module2_5',
                    'module2_6',
                ];
                break;
                
            case "3":
                $include = [
                    'module2_3',
                    'module3_4',
                ];
                break;

            case "4":
                $include = [
                    'module4_1',
                    'module3_4'
                ];
                break;

            case "5":
                $include = [
                    'module5_1',
                    'module4_1'
                ];
                break;

            case "6":
                $include = [
                    'module6_1',
                    'module4_1'
                ];
                break;

            case "7":
                $include = [
                    'module7_1',
                    'module7_2',
                    'module7_3',
                ];
                break;

            case "8":
                $include = [
                    'module8_1',
                    'module5_1'
                ];
                break;

            case "9":
                $include = [
                    'module9_1',
                    'module9_2',
                    'module9_3',
                    'module5_1'
                ];
                break;

            case "10":
                $include = [
                    'module10_1',
                    'module10_2',
                    'module10_3',
                ];
                break;
        }

        $rpam = Rpam::with($include)->find($id);

        return response()->json($rpam);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required'
        ]);

        $rpam = Rpam::find($id);
        if($rpam){
            $rpam->update([
                'name' => $request->name,
                'organization_id' => auth()->user()->organization->id ?? null
            ]);
        }

        switch($request->module){
            case "1":
                $this->updateM1($request, $id);
                break;

            case "2":
                $this->updateM2($request, $id);
                break;

            case "3":
                $this->updateM3($request, $id);
                break;

            case "4":
                $this->updateM4($request, $id);
                break;

            case "5":
                $this->updateM5($request, $id);
                break;

            case "6":
                $this->updateM6($request, $id);
                break;

            case "7":
                $this->updateM7($request, $id);
                break;

            case "8":
                $this->updateM8($request, $id);
                break;

            case "9":
                $this->updateM9($request, $id);
                break;

            case "10":
                $this->updateM10($request, $id);
                break;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
