<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Traits\GenericApiResponse;
use App\Models\Organization;

class OrganizationsController extends Controller
{
    use GenericApiResponse;

    public function index(Request $request)
    {
        if($request->input('per_page')){
            $orgs = Organization::filter($request->all())->paginate($request->per_page ?? 30);
        }else{
            $orgs = Organization::all();
        }

        return response()->json($orgs);
    }

    public function show($id)
    {
        $organization = Organization::find($id);

        if ($organization) {
            return response()->json($organization);
        }

        $this->errorResponse('user tidak ditemukan', 404);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);

        $org = Organization::create($request->all());

        if($org){
            return $this->successResponse('User berhasil dibuat', 200, $org);
        }

        return $this->errorResponse(null, 500);
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);

        $org = Organization::find($id);

        if ($org) {
            $org->update($request->all());
            
            return $this->successResponse('User berhasil dibuat', 200, $org);
        }

        return $this->errorResponse(null, 500);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $organization = Organization::find($id);
        $organization->delete();

        return $this->successResponse('Organisasi Berhasil dihapus');
    }
}
