<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Course;
use App\Models\User;
use App\Models\Organization;

class DashboardController extends Controller
{
    /**
     * Handle the incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function __invoke(Request $request)
    {
        if($request->user()->role !== 'peserta'){
            $total_course = Course::count();
            $total_participant = User::where('role', 'peserta')->count();
            $total_instructor = User::where('role', 'fasilitator')->count();
            $total_organization = Organization::where('is_pdam', true)->count();

            return response()->json([
                'total_course' => $total_course,
                'total_participant' => $total_participant,
                'total_instructor' => $total_instructor,
                'total_organization' => $total_organization
            ]);
        }
    }
}
