<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Traits\GenericApiResponse;
use App\Http\Resources\UserResource;

class AuthController extends Controller
{
    use GenericApiResponse;

    public function login(Request $request)
    {
        $user = User::where('email', $request->email)->first();
        if($user && \Hash::check($request->password, $user->password)){
            $token = $user->createToken('spa_token');

            return response()->json([
                'error' => 0,
                'token' => $token->plainTextToken,
                'user' => new UserResource($user)
            ]);
        }

        return $this->errorResponse('E-mail atau kata sandi salah', 401);
    }
}
