<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;

class CreateUser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'user:create';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'bikin user pake CLI';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $name = $this->ask('Nama');
        $email = $this->ask('E-mail / Username');
        $password = $this->secret('Password');
        $password2 = $this->secret('Ketik kembali password');

        if($password === $password2){
            User::create([
                'name' => $name,
                'email' => $email,
                'password' => bcrypt($password)
            ]);

            $this->info('User '.$name.' ('.$email.') berhasil dibuat');
        }else{
            $this->error('Password tidak sesuai');
        }
    }
}
